/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.framework.handler;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ExecutionContext;
import com.mrcrayfish.configured.impl.framework.message.MessageFramework;
import com.mrcrayfish.configured.network.ServerPlayHelper;
import com.mrcrayfish.configured.platform.Services;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import com.mrcrayfish.framework.api.config.ConfigType;
import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import com.mrcrayfish.framework.network.Network;
import com.mrcrayfish.framework.network.message.play.S2CSyncConfigData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class FrameworkServerHandler {
    public static void handleServerSync(class_3222 player, MessageFramework.Sync message, Consumer<class_2561> disconnect) {
        if (!ServerPlayHelper.canEditServerConfigs(player)) {
            return;
        }
        Constants.LOG.debug("Received Framework server config sync from player: {}", (Object)player.method_5477().getString());
        FrameworkConfigManager.FrameworkConfigImpl config = FrameworkConfigManager.getInstance().getConfig(message.id());
        if (config == null) {
            Constants.LOG.error("Client sent data for a config that doesn't exist: {}", (Object)message.id());
            disconnect.accept((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (config.isReadOnly()) {
            Constants.LOG.error("Client sent data for a read-only config '{}'", (Object)message.id());
            disconnect.accept((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.getType().isServer() || config.getType() == ConfigType.DEDICATED_SERVER) {
            Constants.LOG.error("Client sent data for a config is not supposed to be updated '{}'", (Object)message.id());
            disconnect.accept((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.isLoaded()) {
            Constants.LOG.error("Client tried to perform sync update on an unloaded config. Something went wrong...");
            disconnect.accept((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (FrameworkServerHandler.processSyncData(message, true)) {
            if (config.getType().isSync()) {
                Network.getPlayChannel().sendToAll((Object)new S2CSyncConfigData(message.id(), message.data()));
            }
            ServerPlayHelper.sendMessageToOperators((class_2561)class_2561.method_43469((String)"configured.chat.config_updated", (Object[])new Object[]{player.method_5477(), config.getFileName()}).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}), player);
        } else {
            disconnect.accept((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
        }
    }

    private static boolean processSyncData(MessageFramework.Sync message, boolean server) {
        FrameworkConfigManager.FrameworkConfigImpl config = FrameworkConfigManager.getInstance().getConfig(message.id());
        if (config == null) {
            Constants.LOG.error("No Framework config exists for the id: {}", (Object)message.id());
            return false;
        }
        if (server) {
            if (!config.getType().isServer()) {
                Constants.LOG.error("Received sync update for incorrect Framework config: {}", (Object)message.id());
                return false;
            }
        } else if (!config.getType().isSync()) {
            Constants.LOG.error("Received sync update for a non-sync Framework config: {}", (Object)message.id());
            return false;
        }
        if (config.isReadOnly() || !config.isLoaded()) {
            Constants.LOG.error("Received sync update for incorrect Framework config: {}", (Object)message.id());
            return false;
        }
        try {
            CommentedConfig data = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(message.data()));
            if (!config.isCorrect((UnmodifiableConfig)data)) {
                Constants.LOG.error("Received incorrect Framework config data");
                return false;
            }
            UnmodifiableConfig unmodifiableConfig = config.getConfig();
            if (unmodifiableConfig instanceof Config) {
                Config c = (Config)unmodifiableConfig;
                c.putAll((UnmodifiableConfig)data);
                config.getAllProperties().forEach(AbstractProperty::invalidateCache);
                ((FrameworkConfigEvents.Reload)FrameworkConfigEvents.RELOAD.post()).handle(config.getSource());
                Constants.LOG.debug("Successfully processed sync update for Framework config: {}", (Object)message.id());
                return true;
            }
        }
        catch (ParsingException e) {
            Constants.LOG.error("Received malformed Framework config data", (Throwable)e);
        }
        catch (Exception e) {
            Constants.LOG.error("An exception was thrown when processing Framework config data", (Throwable)e);
        }
        return false;
    }

    public static void handleRequestConfig(class_3222 player, MessageFramework.Request message, Consumer<class_2561> disconnect) {
        ExecutionContext context = new ExecutionContext((class_1657)player);
        if (!context.isDedicatedServer()) {
            Constants.LOG.error("{} tried requesting a config on a non-dedicated server: {}", (Object)player.method_7334().getName(), (Object)message.id());
            disconnect.accept((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!ServerPlayHelper.canEditServerConfigs(player)) {
            return;
        }
        Constants.LOG.debug("Received Framework config request from player: {}", (Object)player.method_5477().getString());
        FrameworkConfigManager.FrameworkConfigImpl config = FrameworkConfigManager.getInstance().getConfig(message.id());
        if (config == null) {
            Constants.LOG.error("{} tried requesting a Framework config that doesn't exist: {}", (Object)player.method_7334().getName(), (Object)message.id());
            disconnect.accept((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.getType().isServer() || config.getType().isSync() || config.getType() == ConfigType.DEDICATED_SERVER) {
            Constants.LOG.error("{} tried requesting a Framework config that is not allowed to be requested: '{}'", (Object)player.method_7334().getName(), (Object)message.id());
            disconnect.accept((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.isLoaded()) {
            Constants.LOG.error("{} tried requesting the Framework config '{}', however it is not loaded. Something went terribly wrong...", (Object)player.method_7334().getName(), (Object)message.id());
            disconnect.accept((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        Services.PLATFORM.sendFrameworkConfigResponse(player, config.asBytes());
    }
}

